# -*- coding:utf-8 -*-
import time
# from mysite.access.models import ACTimezone, ACHolidays, ACGroup, ACCombGroup, ACUnlockComb
__author__ = 'Arvin'


def sync_timezone(sdk, tz_no):
    from mysite.access.models import ACTimezone
    ac_tz = ACTimezone.objects.filter(tz_no=tz_no)
    if ac_tz:
        #print ">>>>>tz>>>>>>>", tz_no, ac_tz[0].tz_period
        timezone = ac_tz[0]
        ret = sdk.set_timezone(tz_no, timezone.tz_period)
        return ret


def sync_holiday(sdk, hd_no):
    from mysite.access.models import ACHolidays
    ac_hd = ACHolidays.objects.filter(holiday_no=hd_no)
    if ac_hd:
        #print ">>>>>>hd>>>>>>", hd_no
        holiday = ac_hd[0]
        ret = sync_timezone(sdk, holiday.tz.tz_no)
        if not ret:
            return ret
        ret = sdk.set_holiday(hd_no, holiday.start_date.month, holiday.start_date.day,
                              holiday.end_date.month, holiday.end_date.day, holiday.tz.tz_no)
        return ret


def sync_group(sdk, group_no):
    from mysite.access.models import ACGroup, ACTimezone
    ac_group = ACGroup.objects.filter(group_no=group_no)
    if ac_group:
        #print ">>>>>group>>>>>>>", group_no
        group = ac_group[0]
        ac_tzs = ACTimezone.objects.filter(tzs=group.tzs).values_list('tz_no', flat=True)
        group_tzs = [0, 0, 0]
        for i, ac_tz in enumerate(ac_tzs):
            ret =sync_timezone(sdk, ac_tz)
            if not ret:
                return ret
            group_tzs[i] = ac_tz
        ret = sdk.set_group(group.group_no, group_tzs[0], group_tzs[1], group_tzs[2],
                            group.include_holidays, group.verification_mode)
        return ret


def sync_emp_with_tz(sdk, pin, sn):
    from comm.att.struct.rmodel_employee import Employee
    from comm.att.struct.rmodel_device import Device
    from ooredis import Set, Dict
    try:
        dev = Device(sn)
        dev = dev.get()
        emp_areas = Set('employee:%s:areas' % pin)
        dev_area = dev.area or 0
        if dev_area in emp_areas:
            emp = Employee(pin)
            emp = emp.get()
            tzs = emp.TimeZones
            if tzs:
                tzs = ([tzs[i:i+4] for i in xrange(0, len(tzs), 4)])[1:]
                tzs = map(int, tzs)
                for tz in tzs:
                    ret = sync_timezone(sdk, tz)
                    if not ret:
                        return ret
            emp.call_sync()
        return True
            # sdk.set_user_info(pin, emp.EName, emp.Password, emp.Privilege)
            # sdk.set_user_tzs(pin, emp.TimeZones)
    except:
        pass


def sync_emp_with_group(sdk, pin, sn):
    from comm.att.struct.rmodel_employee import Employee
    from comm.att.struct.rmodel_device import Device
    from ooredis import Set, Dict
    try:
        dev = Device(sn)
        dev = dev.get()
        emp_areas = Set('employee:%s:areas' % pin)
        dev_area = dev.area or 0
        if dev_area in emp_areas:
            emp = Employee(pin)
            emp = emp.get()
            group_no = emp.AccGroup
            ret = sync_group(sdk, group_no)
            if not ret:
                return ret
            emp.call_sync()
            return True
            # print ">>>>>>>>>>>>sync emp....", sdk
            # print sdk.set_user_info(pin, emp.EName, emp.Password, emp.Privilege)
            # print ">>>>>>>>>>>>sync group....", group_no, sdk
            # print ">>>>>>>>>>>>set emp group...."
            # print sdk.set_user_group(pin, group_no)
    except:
        pass


def sync_combined(sdk, comb_no):
    from mysite.access.models import ACCombGroup
    #print ">>>>>comb_no>>>>>>>", comb_no
    comb_groups = ACCombGroup.objects.filter(comb__comb_no=comb_no).order_by('index')
    combs = [comb_no]
    for comb_group in comb_groups:
        group = comb_group.group
        persons = comb_group.opener_number
        ret = sync_group(sdk, group.group_no)
        if not ret:
            return ret
        for i in range(persons):
            combs.append(group.group_no)
    combs.extend([0, 0, 0, 0, 0])
    #print "============", combs[:6]
    ret = sdk.set_unlock_group(*combs[:6])
    return ret


def door_configure(sdk, key, val):
    # print "[*]Set {0}  --> {1}".format(key, val)
    ret = sdk.set_sys_option(key, val)
    return ret


def door_cmd(sdk, cmd, sn):
    ret = True
    if cmd.startswith('reboot'):
        sdk.restart()
        # ret = sdk.restart()
        # write_log(">>>>reboot>>>ret>>>>>>>>%s>>>" % ret)
    elif cmd.startswith('door'):
        key, val = cmd.replace('door', '').split('|')
        ret = door_configure(sdk, key, val)
    elif cmd.startswith('tz'):
        tz_no = cmd.replace('tz', '')
        ret = sync_timezone(sdk, tz_no)
    elif cmd.startswith('hd'):
        hd_no = cmd.replace('hd', '')
        ret = sync_holiday(sdk, hd_no)
    elif cmd.startswith('group'):
        group_no = cmd.replace('group', '')
        ret = sync_group(sdk, group_no)
    elif cmd.startswith('comb'):
        comb_no = cmd.replace('comb', '')
        ret = sync_combined(sdk, comb_no)
    elif cmd.startswith('emp_tz'):
        pin = cmd.replace('emp_tz', '')
        ret = sync_emp_with_tz(sdk, pin, sn)
    elif cmd.startswith('emp_group'):
        pin = cmd.replace('emp_group', '')
        ret = sync_emp_with_group(sdk, pin, sn)
    # write_log("[*]Result of command(%s): %s" % (cmd, ret))
    if ret is None:
        ret = True
    return ret


def device_check():
    from ooredis import Set
    from comm.sdk.standalonesdk import StandaloneSDK
    from comm.att.struct.sync_models import Device, ObjectDoesNotExist
    #print "Device Heart Checking............"
    while 1:
        # print '[*]device_check live'
        try:
            r_devices = Set('door:heart:died').sscan_iter()
            died_devices = [dev for dev in r_devices]
            for dev in died_devices:
                device = Device(dev)
                try:
                    device.get()
                except:
                    Set('door:heart:died').remove(dev)
                    continue
                sn = device.sn
                ip = device.ipaddress
                port = device.ip_port or 4370
                sdk = StandaloneSDK(ip, port)
                if sdk.connect():
                    sdk.disconnect()
                    Set('door:heart:live').add(dev)
                    Set('door:heart:died').remove(dev)
        except:
            import traceback
            traceback.print_exc()
        time.sleep(5)


def write_log(msg):

    with file('access_log.txt', 'ab+') as f:
        f.write('%s\r\n' % msg)


def cmd_execute():
    from ooredis import Set, SortedSet, List
    from comm.sdk.standalonesdk import StandaloneSDK
    from comm.att.struct.sync_models import Device, ObjectDoesNotExist
    #print "Device Command Checking............"
    while 1:
        # write_log('[*]cmd_execute live')
        try:
            r_devices = Set('door:heart:live').sscan_iter()
            live_devices = [dev for dev in r_devices]
            for dev in live_devices:
                device = Device(dev)
                try:
                    device.get()
                    sn = device.sn
                    ip = device.ipaddress
                    port = device.ip_port or 4370
                # except ObjectDoesNotExist:
                #     Set('door:heart:live').remove(dev)
                except:
                    # print "[*]Device remove....{0}".format(dev)
                    Set('door:heart:live').remove(dev)
                    continue
                dev_cmds = List('door:%s:update' % sn)
                if len(dev_cmds) > 0:
                    sdk = StandaloneSDK(ip, port)
                    if sdk.connect():
                        device_sn = sdk.get_serial_number()
                        support_access = sdk.get_acfunc()
                        if support_access and device_sn == sn:
                            sdk.enable_device(0)
                            stop = False
                            while not stop:
                                if len(dev_cmds) == 0:
                                    stop = True
                                else:
                                    cmd = dev_cmds.lpop()
                                    ret = door_cmd(sdk, cmd, sn)
                                    if not ret:
                                        dev_cmds.lpush(cmd)
                                        break
                            sdk.refresh_data()
                            sdk.enable_device(1)
                        sdk.disconnect()
                    else:
                        Set('door:heart:live').remove(dev)
                        Set('door:heart:died').add(dev)
        except Exception, e:
            import traceback
            traceback.print_exc()
            # write_log('[*]cmd_execute live %s' % e)
        time.sleep(5)


def cmd_execute_process():
    from multiprocessing import Pool, Process
    from ooredis import Set
    from mysite.access.models.ac_door import ACDoor
    Set('door:heart:live').delete()
    Set('door:heart:died').delete()
    doors = ACDoor.objects.all().values_list('device__sn', flat=True)
    for door in doors:
        Set('door:heart:live').add('{0}'.format(door))
    p1 = Process(target=device_check)
    p1.daemon = True
    p1.start()
    p2 = Process(target=cmd_execute)
    p2.daemon = True
    p2.start()
    # pool = Pool(processes=2)
    # pool.apply_async(process_control, ['check'])
    # pool.apply_async(process_control, ['execute'])